/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.seals.config;

import com.buuz135.seals.SealInfo;
import com.buuz135.seals.Seals;
import com.buuz135.seals.client.icon.IIcon;
import com.buuz135.seals.client.icon.ItemStackIcon;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Arrays;
import net.minecraft.block.Blocks;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;

public class JSONConfigLoader {
    private static final JsonDeserializer<ResourceLocation> RESOURCE_LOCATION_DESERIALIZER = (json, typeOfT, context) -> new ResourceLocation(json.getAsString());
    private static final JsonSerializer<ResourceLocation> RESOURCE_LOCATION_SERIALIZER = (src, typeOfSrc, context) -> new JsonPrimitive(src.toString());
    private static final JsonDeserializer<IIcon> ICON_DESERIALIZER = new JsonDeserializer<IIcon>(){

        public IIcon deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return (IIcon)GSON.fromJson(json.getAsJsonObject().get("value"), ItemStackIcon.class);
        }
    };
    private static final JsonSerializer<IIcon> ICON_SERIALIZER = JSONConfigLoader::serialize;
    public static Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, RESOURCE_LOCATION_DESERIALIZER).registerTypeAdapter(ResourceLocation.class, RESOURCE_LOCATION_SERIALIZER).registerTypeAdapter(IIcon.class, ICON_DESERIALIZER).registerTypeAdapter(IIcon.class, ICON_SERIALIZER).setPrettyPrinting().create();
    private File file = new File("./config/seals.json");

    public JSONConfigLoader() {
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
                FileWriter writer = new FileWriter(this.file);
                GSON.toJson(Seals.SEAL_MANAGER.getSeals(), (Appendable)writer);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                FileReader reader = new FileReader(this.file);
                Seals.SEAL_MANAGER.setSeals(Arrays.asList((Object[])GSON.fromJson((Reader)reader, SealInfo[].class)));
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        SealInfo info = new SealInfo(new ResourceLocation("seals:machinist"), "machinist"){

            @Override
            public boolean hasAchievedSeal(ServerPlayerEntity entity) {
                return entity.func_110124_au().toString().equals("d28b7061-fb92-4064-90fb-7e02b95a72a6");
            }

            @Override
            public boolean hasAchievedSealClient(ClientPlayerEntity entity) {
                return entity.func_110124_au().toString().equals("d28b7061-fb92-4064-90fb-7e02b95a72a6");
            }
        };
        info.setInvisible();
        info.setIcon(new ItemStackIcon(Blocks.field_150460_al.getRegistryName()));
        Seals.SEAL_MANAGER.getSeals().add(info);
        info = new SealInfo(new ResourceLocation("seals:patreon"), "munificent"){

            @Override
            public boolean hasAchievedSeal(ServerPlayerEntity entity) {
                return Seals.PATREONS.stream().anyMatch(uuid -> uuid.equals(entity.func_110124_au()));
            }

            @Override
            public boolean hasAchievedSealClient(ClientPlayerEntity entity) {
                return Seals.PATREONS.stream().anyMatch(uuid -> uuid.equals(entity.func_110124_au()));
            }
        };
        info.setInvisible();
        info.setIcon(new ItemStackIcon(Items.field_151156_bN.getRegistryName()));
        Seals.SEAL_MANAGER.getSeals().add(info);
    }

    private static JsonElement serialize(IIcon src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("type", src.getName());
        object.add("value", GSON.toJsonTree((Object)src));
        return object;
    }
}

